//GEMINI-pro DATASET v1.0 Category: Automated Fortune Teller ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>
#include <unistd.h>

#define NUM_THREADS 4

typedef struct {
    int thread_id;
    char *message;
} fortune_data;

void *print_fortune(void *data) {
    fortune_data *data_ptr = (fortune_data *)data;
    int i;

    // Print the fortune message multiple times
    for (i = 0; i < 5; i++) {
        printf("Thread %d: %s\n", data_ptr->thread_id, data_ptr->message);
        sleep(1);
    }

    // Free the allocated memory for the fortune message
    free(data_ptr->message);

    return NULL;
}

int main() {
    pthread_t threads[NUM_THREADS];
    fortune_data data[NUM_THREADS];
    int i;

    // Initialize the random number generator
    srand(time(NULL));

    // Create the threads
    for (i = 0; i < NUM_THREADS; i++) {
        data[i].thread_id = i;
        data[i].message = (char *)malloc(100);
        sprintf(data[i].message, "Fortune from thread %d: %d", i, rand() % 100);
        pthread_create(&threads[i], NULL, print_fortune, (void *)&data[i]);
    }

    // Join the threads
    for (i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}