//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOSTS 10

typedef struct Ghost {
    char name[20];
    int room_num;
    int spirit_level;
    int active;
} Ghost;

Ghost ghosts[MAX_GHOSTS];

void initializeGhosts() {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        ghosts[i].name[0] = '\0';
        ghosts[i].room_num = -1;
        ghosts[i].spirit_level = 0;
        ghosts[i].active = 0;
    }
}

void addGhost(char *name, int room_num, int spirit_level) {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        if (ghosts[i].name[0] == '\0') {
            strcpy(ghosts[i].name, name);
            ghosts[i].room_num = room_num;
            ghosts[i].spirit_level = spirit_level;
            ghosts[i].active = 1;
            return;
        }
    }
    printf("Error: No more ghosts can be added.\n");
}

int main() {
    initializeGhosts();

    addGhost("John Doe", 1, 5);
    addGhost("Jane Doe", 2, 3);
    addGhost("Mr. Smith", 3, 7);

    srand(time(NULL));

    for (int i = 0; i < 10; i++) {
        int random_ghost = rand() % MAX_GHOSTS;
        if (ghosts[random_ghost].active) {
            printf("Ghost: %s\n", ghosts[random_ghost].name);
            printf("Room: %d\n", ghosts[random_ghost].room_num);
            printf("Spirit Level: %d\n", ghosts[random_ghost].spirit_level);
            printf("\n");
        }
    }

    return 0;
}