//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>

#define ROBOT_DEV "/dev/ttyUSB0"
#define ROBOT_BAUD B115200

int main()
{
    int fd;
    struct termios options;

    // Open the serial port
    fd = open(ROBOT_DEV, O_RDWR | O_NOCTTY | O_NDELAY);
    if (fd == -1) {
        perror("open");
        return EXIT_FAILURE;
    }

    // Set the serial port options
    tcgetattr(fd, &options);
    cfsetispeed(&options, ROBOT_BAUD);
    cfsetospeed(&options, ROBOT_BAUD);
    options.c_cflag |= (CLOCAL | CREAD);
    options.c_cflag &= ~PARENB;
    options.c_cflag &= ~CSTOPB;
    options.c_cflag &= ~CSIZE;
    options.c_cflag |= CS8;
    tcsetattr(fd, TCSANOW, &options);

    // Send a command to the robot
    write(fd, "F\n", 2);

    // Wait for the robot to respond
    usleep(500000);

    // Read the response from the robot
    char buffer[1024];
    int bytes_read = read(fd, buffer, sizeof(buffer));
    if (bytes_read > 0) {
        printf("%s", buffer);
    }

    // Close the serial port
    close(fd);

    return EXIT_SUCCESS;
}