//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: complete
#include <stdio.h>
#include <stdlib.h>

#define MAX_PROCESS 5

struct process {
    int id;
    int arrival_time;
    int burst_time;
    int waiting_time;
    int turn_around_time;
};

void calculate_waiting_time(struct process *process_list) {
    for (int i = 0; i < MAX_PROCESS; i++) {
        process_list[i].waiting_time = process_list[i].arrival_time - process_list[i].burst_time;
    }
}

void calculate_turn_around_time(struct process *process_list) {
    for (int i = 0; i < MAX_PROCESS; i++) {
        process_list[i].turn_around_time = process_list[i].waiting_time + process_list[i].burst_time;
    }
}

int main() {
    struct process process_list[MAX_PROCESS];

    // Create some processes
    process_list[0].id = 0;
    process_list[0].arrival_time = 0;
    process_list[0].burst_time = 5;

    process_list[1].id = 1;
    process_list[1].arrival_time = 2;
    process_list[1].burst_time = 4;

    process_list[2].id = 2;
    process_list[2].arrival_time = 4;
    process_list[2].burst_time = 3;

    process_list[3].id = 3;
    process_list[3].arrival_time = 6;
    process_list[3].burst_time = 2;

    process_list[4].id = 4;
    process_list[4].arrival_time = 8;
    process_list[4].burst_time = 1;

    // Calculate waiting time and turn around time
    calculate_waiting_time(process_list);
    calculate_turn_around_time(process_list);

    // Print the results
    for (int i = 0; i < MAX_PROCESS; i++) {
        printf("Process ID: %d, Arrival Time: %d, Burst Time: %d, Waiting Time: %d, Turn Around Time: %d\n", process_list[i].id, process_list[i].arrival_time, process_list[i].burst_time, process_list[i].waiting_time, process_list[i].turn_around_time);
    }

    return 0;
}