//Falcon-180B DATASET v1.0 Category: Elevator Simulation ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_FLOORS 20
#define MAX_PASSENGERS 10
#define MAX_DESTINATIONS 20

typedef struct {
    int id;
    int destination;
} passenger;

typedef struct {
    int current_floor;
    int destination;
    int speed;
} elevator;

void initialize_elevator(elevator* e) {
    e->current_floor = 0;
    e->destination = 0;
    e->speed = 1;
}

void initialize_passenger(passenger* p) {
    p->id = rand() % 100;
    p->destination = rand() % (MAX_FLOORS - 1) + 1;
}

void print_passenger(passenger p) {
    printf("passenger %d is going to floor %d\n", p.id, p.destination);
}

void print_elevator(elevator e) {
    printf("elevator is on floor %d, going to floor %d, speed %d\n", e.current_floor, e.destination, e.speed);
}

void move_elevator(elevator* e) {
    if (e->destination > e->current_floor) {
        e->current_floor++;
    } else if (e->destination < e->current_floor) {
        e->current_floor--;
    }
}

void simulate_elevator(elevator e, passenger* passengers, int num_passengers) {
    int i;
    for (i = 0; i < num_passengers; i++) {
        if (e.destination == passengers[i].destination) {
            e.destination = 0;
            break;
        }
    }
    move_elevator(&e);
}

int main() {
    srand(time(0));
    elevator e;
    initialize_elevator(&e);
    passenger passengers[MAX_PASSENGERS];
    int num_passengers = rand() % MAX_PASSENGERS + 1;
    initialize_passenger(passengers);
    int i;
    for (i = 0; i < num_passengers; i++) {
        printf("passenger %d entered the elevator\n", passengers[i].id);
        simulate_elevator(e, passengers, num_passengers);
        print_elevator(e);
        print_passenger(passengers[i]);
    }
    return 0;
}