//Falcon-180B DATASET v1.0 Category: Poker Game ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define DECK_SIZE 52
#define NUM_PLAYERS 2
#define NUM_CARDS_DEALT 5

typedef struct {
    char *name;
    int hand[NUM_CARDS_DEALT];
} Player;

void shuffle_deck(int deck[DECK_SIZE]) {
    srand(time(NULL));
    for (int i = 0; i < DECK_SIZE; i++) {
        int j = rand() % DECK_SIZE;
        int temp = deck[i];
        deck[i] = deck[j];
        deck[j] = temp;
    }
}

int compare_hands(const void *a, const void *b) {
    const int *hand_a = a;
    const int *hand_b = b;

    for (int i = 0; i < NUM_CARDS_DEALT; i++) {
        if (hand_a[i] > hand_b[i]) {
            return 1;
        } else if (hand_a[i] < hand_b[i]) {
            return -1;
        }
    }

    return 0;
}

void deal_cards(int deck[DECK_SIZE], Player players[NUM_PLAYERS]) {
    for (int i = 0; i < NUM_PLAYERS; i++) {
        for (int j = 0; j < NUM_CARDS_DEALT; j++) {
            players[i].hand[j] = deck[j];
        }
    }
}

void print_hand(const char *name, int hand[NUM_CARDS_DEALT]) {
    printf("%s's hand: ", name);
    for (int i = 0; i < NUM_CARDS_DEALT; i++) {
        printf("%d ", hand[i]);
    }
    printf("\n");
}

int main() {
    int deck[DECK_SIZE] = {0};
    for (int i = 0; i < DECK_SIZE; i++) {
        deck[i] = i;
    }

    shuffle_deck(deck);

    Player players[NUM_PLAYERS] = {{"Alice"}, {"Bob"}};

    deal_cards(deck, players);

    qsort(players, NUM_PLAYERS, sizeof(Player), compare_hands);

    printf("Round 1:\n");
    print_hand(players[0].name, players[0].hand);
    print_hand(players[1].name, players[1].hand);

    return 0;
}