//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define MAGIC_NUMBER 42

struct Complex {
    double real;
    double imag;
};

void complex_add(struct Complex a, struct Complex b, struct Complex *sum) {
    sum->real = a.real + b.real;
    sum->imag = a.imag + b.imag;
}

void complex_subtract(struct Complex a, struct Complex b, struct Complex *diff) {
    diff->real = a.real - b.real;
    diff->imag = a.imag - b.imag;
}

void complex_multiply(struct Complex a, struct Complex b, struct Complex *prod) {
    prod->real = a.real * b.real - a.imag * b.imag;
    prod->imag = 2 * a.real * b.imag + a.imag * b.real;
}

void complex_divide(struct Complex num, struct Complex denom, struct Complex *res) {
    double num_r = num.real, num_i = num.imag;
    double denom_r = denom.real, denom_i = denom.imag;
    double q_r, q_i, r_r, r_i;

    if (denom_r == 0) {
        printf("Error: division by zero!\n");
        return;
    }

    q_r = num_r / denom_r;
    q_i = num_i / denom_i;

    r_r = q_r - (q_i * denom_r) / denom_i;
    r_i = q_i + (q_r * denom_i) / denom_r;

    res->real = r_r;
    res->imag = r_i;
}

int main() {
    struct Complex a, b, c, d;
    double x, y, z, w;

    // Example 1: Addition
    a.real = 2, a.imag = 3;
    b.real = 4, b.imag = 5;
    c.real = 0, c.imag = 0;
    complex_add(a, b, &c);
    printf("a + b = %f + %fi = %f + %fi\n", a.real, a.imag, c.real, c.imag);

    // Example 2: Subtraction
    a.real = 2, a.imag = 3;
    b.real = 4, b.imag = 5;
    c.real = 0, c.imag = 0;
    complex_subtract(a, b, &c);
    printf("a - b = %f + %fi = %f + %fi\n", a.real, a.imag, c.real, c.imag);

    // Example 3: Multiplication
    a.real = 2, a.imag = 3;
    b.real = 4, b.imag = 5;
    c.real = 0, c.imag = 0;
    complex_multiply(a, b, &c);
    printf("a * b = %f + %fi * %f + %fi = %f + %fi\n", a.real, a.imag, b.real, b.imag, c.real, c.imag);

    // Example 4: Division
    a.real = 2, a.imag = 3;
    b.real = 4, b.imag = 5;
    c.real = 1, c.imag = 0;
    complex_divide(a, b, &c);
    printf("a / b = %f + %fi / %f + %fi = %f + %fi\n", a.real, a.imag, b.real, b.imag, c.real, c.imag);

    return 0;
}