//GEMINI-pro DATASET v1.0 Category: Cryptography Implementation ; Style: multivariable
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#define KEY_SIZE 256
#define BLOCK_SIZE 16

unsigned char key[KEY_SIZE];
unsigned char iv[BLOCK_SIZE];

void generate_key(void);
void generate_iv(void);
void encrypt(unsigned char *plaintext, unsigned char *ciphertext);
void decrypt(unsigned char *ciphertext, unsigned char *plaintext);

int main(void)
{
    unsigned char plaintext[BLOCK_SIZE] = "Hello, world!";
    unsigned char ciphertext[BLOCK_SIZE];

    generate_key();
    generate_iv();

    encrypt(plaintext, ciphertext);

    decrypt(ciphertext, plaintext);

    printf("Plaintext: %s\nCiphertext: %s\n", plaintext, ciphertext);

    return 0;
}

void generate_key(void)
{
    int i;

    for (i = 0; i < KEY_SIZE; i++)
    {
        key[i] = rand() % 256;
    }
}

void generate_iv(void)
{
    int i;

    for (i = 0; i < BLOCK_SIZE; i++)
    {
        iv[i] = rand() % 256;
    }
}

void encrypt(unsigned char *plaintext, unsigned char *ciphertext)
{
    int i;

    for (i = 0; i < BLOCK_SIZE; i++)
    {
        ciphertext[i] = plaintext[i] ^ key[i];
    }
}

void decrypt(unsigned char *ciphertext, unsigned char *plaintext)
{
    int i;

    for (i = 0; i < BLOCK_SIZE; i++)
    {
        plaintext[i] = ciphertext[i] ^ key[i];
    }
}