//GEMINI-pro DATASET v1.0 Category: Temperature monitor ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>

// I2C device file
#define I2C_DEV "/dev/i2c-1"

// I2C address of the TMP102 sensor
#define TMP102_ADDR 0x48

// TMP102 registers
#define TMP102_REG_TEMP 0x00

int main()
{
    int fd, ret;
    int temp;

    // Open the I2C device file
    fd = open(I2C_DEV, O_RDWR);
    if (fd < 0) {
        perror("open");
        return -1;
    }

    // Set the I2C slave address
    ret = ioctl(fd, I2C_SLAVE, TMP102_ADDR);
    if (ret < 0) {
        perror("ioctl");
        close(fd);
        return -1;
    }

    // Read the temperature register
    ret = read(fd, &temp, 2);
    if (ret < 0) {
        perror("read");
        close(fd);
        return -1;
    }

    // Convert the temperature to Celsius
    temp = (temp >> 4) * 1.0;

    // Print the temperature
    printf("Temperature: %.2f C\n", temp);

    // Close the I2C device file
    close(fd);

    return 0;
}