//Gemma-7B DATASET v1.0 Category: Banking Record System ; Style: post-apocalyptic
#include <stdio.h>
#include <string.h>

#define MAX_RECORDS 10

typedef struct Record
{
    char name[20];
    int account_number;
    double balance;
} Record;

Record records[MAX_RECORDS];

void deposit(int account_number, double amount)
{
    for (int i = 0; i < MAX_RECORDS; i++)
    {
        if (records[i].account_number == account_number)
        {
            records[i].balance += amount;
            break;
        }
    }
}

void withdraw(int account_number, double amount)
{
    for (int i = 0; i < MAX_RECORDS; i++)
    {
        if (records[i].account_number == account_number)
        {
            if (records[i].balance >= amount)
            {
                records[i].balance -= amount;
                break;
            }
        }
    }
}

void transfer(int from_account_number, int to_account_number, double amount)
{
    for (int i = 0; i < MAX_RECORDS; i++)
    {
        if (records[i].account_number == from_account_number)
        {
            records[i].balance -= amount;
            break;
        }
    }

    for (int j = 0; j < MAX_RECORDS; j++)
    {
        if (records[j].account_number == to_account_number)
        {
            records[j].balance += amount;
            break;
        }
    }
}

void print_records()
{
    for (int i = 0; i < MAX_RECORDS; i++)
    {
        printf("Name: %s, Account Number: %d, Balance: $%.2lf\n", records[i].name, records[i].account_number, records[i].balance);
    }
}

int main()
{
    deposit(123, 100);
    deposit(456, 50);
    withdraw(123, 20);
    transfer(123, 456, 25);
    print_records();

    return 0;
}