//GPT-4o-mini DATASET v1.0 Category: Compression algorithms ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void compress(const char *input, char *output) {
    int count = 1;
    int j = 0;

    for (int i = 0; i < strlen(input); i++) {
        if (input[i] == input[i + 1]) {
            count++;
        } else {
            // Store the character and its count
            output[j++] = input[i];
            output[j++] = count + '0'; // Convert count to character
            count = 1; // Reset count for the next character
        }
    }
    output[j] = '\0'; // Null-terminate the compressed string
}

void decompress(const char *input, char *output) {
    int j = 0;
    
    for (int i = 0; i < strlen(input); i++) {
        char ch = input[i];
        int count = input[i + 1] - '0'; // Get count as integer
        for (int k = 0; k < count; k++) {
            output[j++] = ch; // Repeat character count times
        }
        i++; // Move to the next character
    }
    output[j] = '\0'; // Null-terminate the decompressed string
}

int main() {
    const char *original = "aaabbbcccaaa";
    char compressed[100];
    char decompressed[100];

    printf("Original string: %s\n", original);
    
    // Compressing the string
    compress(original, compressed);
    printf("Compressed string: %s\n", compressed);

    // Decompressing the string
    decompress(compressed, decompressed);
    printf("Decompressed string: %s\n", decompressed);

    // Verify decompression
    if (strcmp(original, decompressed) == 0) {
        printf("Decompression successful! The decompressed string matches the original.\n");
    } else {
        printf("Oh no! The decompressed string does not match the original.\n");
    }

    return 0;
}