//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <unistd.h>
#include <string.h>

// Define the message structure.
typedef struct {
    long mtype;
    char mtext[1024];
} message_t;

// The main function.
int main() {
    // Create a message queue.
    int msgqid = msgget(IPC_PRIVATE, IPC_CREAT | 0666);
    if (msgqid == -1) {
        perror("msgget");
        exit(EXIT_FAILURE);
    }

    // Create a child process.
    pid_t childpid = fork();
    if (childpid == -1) {
        perror("fork");
        exit(EXIT_FAILURE);
    }

    // If this is the child process, send a message to the queue.
    if (childpid == 0) {
        message_t msg;
        msg.mtype = 1;
        strcpy(msg.mtext, "Hello from the child process!");
        if (msgsnd(msgqid, &msg, sizeof(msg.mtext), 0) == -1) {
            perror("msgsnd");
            exit(EXIT_FAILURE);
        }
    }
    // If this is the parent process, wait for a message from the queue.
    else {
        message_t msg;
        if (msgrcv(msgqid, &msg, sizeof(msg.mtext), 1, 0) == -1) {
            perror("msgrcv");
            exit(EXIT_FAILURE);
        }
        printf("Received message: %s\n", msg.mtext);
    }

    // Remove the message queue.
    if (msgctl(msgqid, IPC_RMID, NULL) == -1) {
        perror("msgctl");
        exit(EXIT_FAILURE);
    }

    return EXIT_SUCCESS;
}