//Gemma-7B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUFFER_SIZE 1024

typedef struct Calculator {
    char buffer[MAX_BUFFER_SIZE];
    int position;
    double result;
} Calculator;

void initialize_calculator(Calculator *calculator) {
    calculator->position = 0;
    calculator->result = 0.0;
    calculator->buffer[0] = '\0';
}

void append_digit(Calculator *calculator, int digit) {
    int i = calculator->position;

    if (calculator->position >= MAX_BUFFER_SIZE - 1) {
        return;
    }

    calculator->buffer[i] = digit + '0';
    calculator->position++;
    calculator->buffer[calculator->position] = '\0';
}

void clear_calculator(Calculator *calculator) {
    initialize_calculator(calculator);
}

void calculate_result(Calculator *calculator) {
    double number1 = atof(calculator->buffer);
    double number2 = calculator->result;
    double result = 0.0;

    switch (calculator->buffer[0]) {
        case '+':
            result = number1 + number2;
            break;
        case '-':
            result = number1 - number2;
            break;
        case '*':
            result = number1 * number2;
            break;
        case '/':
            if (number2 == 0) {
                return;
            }
            result = number1 / number2;
            break;
    }

    calculator->result = result;
}

int main() {
    Calculator calculator;
    initialize_calculator(&calculator);

    // Example usage
    append_digit(&calculator, 5);
    append_digit(&calculator, 2);
    append_digit(&calculator, 3);
    append_digit(&calculator, '+');
    append_digit(&calculator, 4);
    append_digit(&calculator, 6);
    append_digit(&calculator, '=');

    calculate_result(&calculator);

    printf("The result is: %.2lf", calculator.result);

    clear_calculator(&calculator);

    return 0;
}