//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define MAX_STOCKS 100
#define MAX_NAME_LEN 50
#define MAX_SYMBOL_LEN 10
#define MAX_PRICE_LEN 20
#define MAX_DATE_LEN 20
#define MAX_TIME_LEN 20

typedef struct {
    char name[MAX_NAME_LEN + 1];
    char symbol[MAX_SYMBOL_LEN + 1];
    char price[MAX_PRICE_LEN + 1];
    char date[MAX_DATE_LEN + 1];
    char time[MAX_TIME_LEN + 1];
} stock_t;

stock_t stocks[MAX_STOCKS];
int num_stocks = 0;

void add_stock(char* name, char* symbol, char* price, char* date, char* time) {
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: Maximum number of stocks reached.\n");
        return;
    }

    strcpy(stocks[num_stocks].name, name);
    strcpy(stocks[num_stocks].symbol, symbol);
    strcpy(stocks[num_stocks].price, price);
    strcpy(stocks[num_stocks].date, date);
    strcpy(stocks[num_stocks].time, time);

    num_stocks++;
}

void print_stocks() {
    printf("Name\tSymbol\tPrice\tDate\tTime\n");

    for (int i = 0; i < num_stocks; i++) {
        printf("%s\t%s\t%s\t%s\t%s\n", stocks[i].name, stocks[i].symbol, stocks[i].price, stocks[i].date, stocks[i].time);
    }
}

int main() {
    time_t now = time(NULL);
    struct tm* current_time = localtime(&now);

    char date[MAX_DATE_LEN + 1] = {0};
    strftime(date, MAX_DATE_LEN, "%Y-%m-%d", current_time);

    char time[MAX_TIME_LEN + 1] = {0};
    strftime(time, MAX_TIME_LEN, "%H:%M:%S", current_time);

    add_stock("Apple", "AAPL", "145.52", date, time);
    add_stock("Google", "GOOG", "1012.25", date, time);
    add_stock("Microsoft", "MSFT", "56.57", date, time);

    print_stocks();

    return 0;
}