//Gemma-7B DATASET v1.0 Category: Simple HTTP Proxy ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>

#define BUFFER_SIZE 1024

int main()
{
    int sockfd, newsockfd, clientfd, portno, nread, nwrite;
    char buffer[BUFFER_SIZE];
    struct sockaddr_in server_addr, client_addr;
    char hostname[256];

    // Bind to a port
    sockfd = socket(AF_INET, SOCK_STREAM, htons(8080));
    if (sockfd < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for clients
    listen(sockfd, &clientfd);

    // Accept client connection
    newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, NULL);
    if (newsockfd < 0)
    {
        perror("Error accepting client connection");
        exit(1);
    }

    // Get client hostname
    gethostname(client_addr.sin_addr.s_addr, hostname);

    // Print client hostname
    printf("Client connected from: %s\n", hostname);

    // Read client request
    nread = read(newsockfd, buffer, BUFFER_SIZE);
    if (nread < 0)
    {
        perror("Error reading client request");
        exit(1);
    }

    // Write client request to server
    nwrite = write(sockfd, buffer, nread);
    if (nwrite < 0)
    {
        perror("Error writing client request to server");
        exit(1);
    }

    // Read server response
    nread = read(sockfd, buffer, BUFFER_SIZE);
    if (nread < 0)
    {
        perror("Error reading server response");
        exit(1);
    }

    // Write server response to client
    nwrite = write(newsockfd, buffer, nread);
    if (nwrite < 0)
    {
        perror("Error writing server response to client");
        exit(1);
    }

    // Close client connection
    close(newsockfd);

    return 0;
}