//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LENGTH 50
#define MAX_DESCRIPTION_LENGTH 200

typedef struct {
    int id;
    char name[MAX_NAME_LENGTH];
    char description[MAX_DESCRIPTION_LENGTH];
    int quantity;
    float price;
} product;

product products[MAX_PRODUCTS];
int num_products = 0;

void add_product(product p) {
    if (num_products == MAX_PRODUCTS) {
        printf("Error: warehouse is full\n");
        return;
    }

    products[num_products++] = p;
}

void remove_product(int id) {
    int i;

    for (i = 0; i < num_products; i++) {
        if (products[i].id == id) {
            break;
        }
    }

    if (i == num_products) {
        printf("Error: product not found\n");
        return;
    }

    for (i++; i < num_products; i++) {
        products[i - 1] = products[i];
    }

    num_products--;
}

void update_product(int id, product p) {
    int i;

    for (i = 0; i < num_products; i++) {
        if (products[i].id == id) {
            break;
        }
    }

    if (i == num_products) {
        printf("Error: product not found\n");
        return;
    }

    products[i] = p;
}

void print_products() {
    int i;

    printf("Products:\n");
    for (i = 0; i < num_products; i++) {
        printf("ID: %d\n", products[i].id);
        printf("Name: %s\n", products[i].name);
        printf("Description: %s\n", products[i].description);
        printf("Quantity: %d\n", products[i].quantity);
        printf("Price: %f\n", products[i].price);
        printf("\n");
    }
}

int main() {
    product p1 = {1, "Product 1", "Description of product 1", 10, 10.00};
    product p2 = {2, "Product 2", "Description of product 2", 20, 20.00};
    product p3 = {3, "Product 3", "Description of product 3", 30, 30.00};

    add_product(p1);
    add_product(p2);
    add_product(p3);

    print_products();

    remove_product(2);

    print_products();

    product p4 = {2, "Updated product 2", "Updated description of product 2", 40, 40.00};

    update_product(2, p4);

    print_products();

    return 0;
}