//GPT-4o-mini DATASET v1.0 Category: Classical Circuit Simulator ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdbool.h>

#define MAX_ELEMENTS 100

typedef enum { RESISTOR, CAPACITOR, INDUCTOR } ElementType;

typedef struct {
    ElementType type;
    double value; // Value in ohms, farads, or henries
    char name[10];
} CircuitElement;

typedef struct {
    CircuitElement elements[MAX_ELEMENTS];
    int count;
} Circuit;

void addElement(Circuit *circuit, const char *name, ElementType type, double value) {
    if (circuit->count >= MAX_ELEMENTS) {
        printf("Circuit is full!\n");
        return;
    }
    CircuitElement element;
    element.type = type;
    element.value = value;
    snprintf(element.name, sizeof(element.name), "%s", name);
    circuit->elements[circuit->count++] = element;
}

double calculateTotalResistance(Circuit *circuit) {
    double total = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->elements[i].type == RESISTOR) {
            total += circuit->elements[i].value;
        }
    }
    return total;
}

double calculateTotalCapacitance(Circuit *circuit) {
    double total = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->elements[i].type == CAPACITOR) {
            total += 1.0 / circuit->elements[i].value;
        }
    }
    return (total > 0) ? 1.0 / total : 0; // Return 0 if no capacitors
}

double calculateTotalInductance(Circuit *circuit) {
    double total = 0;
    for (int i = 0; i < circuit->count; i++) {
        if (circuit->elements[i].type == INDUCTOR) {
            total += circuit->elements[i].value;
        }
    }
    return total;
}

void displayCircuit(Circuit *circuit) {
    if (circuit->count == 0) {
        printf("Circuit is empty.\n");
        return;
    }
    
    printf("Circuit elements:\n");
    for (int i = 0; i < circuit->count; i++) {
        printf("%s: ", circuit->elements[i].name);
        
        switch (circuit->elements[i].type) {
            case RESISTOR:
                printf("Resistor (%.2f Ohms)\n", circuit->elements[i].value);
                break;
            case CAPACITOR:
                printf("Capacitor (%.2f Farads)\n", circuit->elements[i].value);
                break;
            case INDUCTOR:
                printf("Inductor (%.2f Henries)\n", circuit->elements[i].value);
                break;
        }
    }
}

int main() {
    Circuit circuit;
    circuit.count = 0;

    addElement(&circuit, "R1", RESISTOR, 100);
    addElement(&circuit, "C1", CAPACITOR, 0.001);
    addElement(&circuit, "L1", INDUCTOR, 0.01);
    addElement(&circuit, "R2", RESISTOR, 150);
    
    displayCircuit(&circuit);
    
    double totalResistance = calculateTotalResistance(&circuit);
    double totalCapacitance = calculateTotalCapacitance(&circuit);
    double totalInductance = calculateTotalInductance(&circuit);
    
    printf("\nTotal Resistance: %.2f Ohms\n", totalResistance);
    printf("Total Capacitance: %.2f Farads\n", totalCapacitance);
    printf("Total Inductance: %.2f Henries\n", totalInductance);
    
    return 0;
}