//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 12
#define NUM_PASSWORDS 5

// Function to generate a random password
void generate_password(char *password) {
    const char *lowercase = "abcdefghijklmnopqrstuvwxyz";
    const char *uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    const char *digits = "0123456789";
    const char *special_chars = "!@#$%^&*()-_=+[]{}|;:,.<>?";

    // Seed the random number generator
    srand(time(NULL));

    // Ensure each password has at least one of each character type
    password[0] = lowercase[rand() % strlen(lowercase)];
    password[1] = uppercase[rand() % strlen(uppercase)];
    password[2] = digits[rand() % strlen(digits)];
    password[3] = special_chars[rand() % strlen(special_chars)];

    // Fill the rest of the password with random characters from all types
    const char *all_chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-_=+[]{}|;:,.<>?";
    
    for (int i = 4; i < PASSWORD_LENGTH; i++) {
        password[i] = all_chars[rand() % strlen(all_chars)];
    }

    // Shuffle the password to enhance security
    for (int i = 0; i < PASSWORD_LENGTH; i++) {
        int j = rand() % PASSWORD_LENGTH;
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }

    // Null-terminate the password string
    password[PASSWORD_LENGTH] = '\0';
}

// Function to display a password
void display_passwords(int num_passwords) {
    char password[PASSWORD_LENGTH + 1]; // Extra byte for the null-terminator
    printf("Generated Passwords:\n");
    for (int i = 0; i < num_passwords; i++) {
        generate_password(password);
        printf("%d: %s\n", i + 1, password);
    }
}

int main() {
    printf("Welcome to the Secure Password Generator!\n");
    printf("Generating %d secure passwords of length %d...\n", NUM_PASSWORDS, PASSWORD_LENGTH);
    
    display_passwords(NUM_PASSWORDS);

    printf("Passwords generated successfully. Remember to store them securely!\n");
    return 0;
}