//Falcon-180B DATASET v1.0 Category: Searching algorithm ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>

// Define the maximum size of the array
#define MAX_SIZE 1000

// Define the structure of the element to be stored in the array
typedef struct {
    int value;
    int index;
} element;

// Define the array of elements
element arr[MAX_SIZE];

// Define the number of elements in the array
int num_elements = 0;

// Define the function to insert an element in the array
void insert_element(int value) {
    if (num_elements == MAX_SIZE) {
        printf("Error: Array is full\n");
        return;
    }

    // Find the index where the element should be inserted
    int i = 0;
    while (i < num_elements && arr[i].value < value) {
        i++;
    }

    // Insert the element in the array
    arr[i].value = value;
    arr[i].index = i;
    num_elements++;
}

// Define the function to search for an element in the array
int search_element(int value) {
    int i = 0;

    // Search for the element in the array
    while (i < num_elements && arr[i].value < value) {
        i++;
    }

    // If the element is not found, return -1
    if (i == num_elements || arr[i].value!= value) {
        return -1;
    }

    // Return the index of the element
    return arr[i].index;
}

// Define the main function
int main() {
    // Initialize the array
    num_elements = 0;

    // Insert some elements in the array
    insert_element(5);
    insert_element(10);
    insert_element(15);

    // Search for an element in the array
    int index = search_element(10);

    // Print the result
    if (index == -1) {
        printf("Element not found\n");
    } else {
        printf("Element found at index %d\n", index);
    }

    return 0;
}