//Falcon-180B DATASET v1.0 Category: Bucket Sort Implementation ; Style: energetic
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 100

// Function to swap two elements
void swap(int* a, int* b) {
    int temp = *a;
    *a = *b;
    *b = temp;
}

// Function to find the index of the minimum element in the array
int findMinIndex(int arr[], int size) {
    int minIndex = 0;
    for (int i = 1; i < size; i++) {
        if (arr[i] < arr[minIndex]) {
            minIndex = i;
        }
    }
    return minIndex;
}

// Function to perform bucket sort
void bucketSort(int arr[], int size) {
    int bucket[MAX_SIZE];
    int minIndex;
    for (int i = 0; i < size; i++) {
        minIndex = findMinIndex(arr, size);
        swap(&arr[minIndex], &arr[0]);
        int j = 0;
        while (j < size) {
            if (arr[j] == arr[0]) {
                swap(&arr[j], &arr[0]);
                j++;
            } else {
                j++;
            }
        }
        printf("After %d iterations of bucket sort, the array is: ", i+1);
        for (int k = 0; k < size; k++) {
            printf("%d ", arr[k]);
        }
        printf("\n");
    }
}

int main() {
    int arr[] = { 7, 1, 3, 2, 5, 6, 8, 9, 4 };
    int size = sizeof(arr) / sizeof(arr[0]);
    printf("The initial array is: ");
    for (int i = 0; i < size; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
    bucketSort(arr, size);
    return 0;
}