//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESS 5
#define MAX_TIME 10

// Define a structure to represent a process
struct process {
  int pid;
  int arrival_time;
  int service_time;
  int waiting_time;
  int turnaround_time;
};

// Function to compare processes
int compare(struct process *a, struct process *b) {
  return a->arrival_time - b->arrival_time;
}

// Function to calculate waiting time and turnaround time
void calculate(struct process *p) {
  p->waiting_time = p->arrival_time - p->service_time;
  p->turnaround_time = p->waiting_time + p->service_time;
}

int main() {
  // Create an array of processes
  struct process processes[MAX_PROCESS];

  // Initialize the processes
  for (int i = 0; i < MAX_PROCESS; i++) {
    processes[i].pid = i + 1;
    processes[i].arrival_time = rand() % MAX_TIME;
    processes[i].service_time = rand() % MAX_TIME;
  }

  // Sort the processes by arrival time
  qsort(processes, MAX_PROCESS, sizeof(struct process), compare);

  // Calculate waiting time and turnaround time for each process
  for (int i = 0; i < MAX_PROCESS; i++) {
    calculate(&processes[i]);
  }

  // Print the results
  for (int i = 0; i < MAX_PROCESS; i++) {
    printf("Process ID: %d, Arrival Time: %d, Service Time: %d, Waiting Time: %d, Turnaround Time: %d\n", processes[i].pid, processes[i].arrival_time, processes[i].service_time, processes[i].waiting_time, processes[i].turnaround_time);
  }

  return 0;
}