//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: complex
#include <stdio.h>
#include <stdlib.h>

#define MAX_STOCK_NUM 10

typedef struct Stock {
    char name[20];
    double currentPrice;
    double previousPrice;
    int quantity;
} Stock;

void updateStock(Stock *stock, double newPrice) {
    stock->previousPrice = stock->currentPrice;
    stock->currentPrice = newPrice;
}

void calculateTotalValue(Stock *stock) {
    double totalValue = stock->quantity * stock->currentPrice;
    printf("%s's total value is $%.2lf.\n", stock->name, totalValue);
}

int main() {
    Stock stocks[MAX_STOCK_NUM];
    for (int i = 0; i < MAX_STOCK_NUM; i++) {
        stocks[i].name[0] = '\0';
        stocks[i].currentPrice = 0.0;
        stocks[i].previousPrice = 0.0;
        stocks[i].quantity = 0;
    }

    // Add some sample stocks
    strcpy(stocks[0].name, "Apple");
    updateStock(&stocks[0], 100.0);
    stocks[0].quantity = 100;

    strcpy(stocks[1].name, "Microsoft");
    updateStock(&stocks[1], 90.0);
    stocks[1].quantity = 50;

    strcpy(stocks[2].name, "Google");
    updateStock(&stocks[2], 80.0);
    stocks[2].quantity = 20;

    // Calculate and print total value for each stock
    for (int i = 0; i < MAX_STOCK_NUM; i++) {
        calculateTotalValue(&stocks[i]);
    }

    return 0;
}