//GEMINI-pro DATASET v1.0 Category: GPS Navigation Simulation ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define PI 3.14159265

// Earth's radius in kilometers
#define EARTH_RADIUS 6371

// Conversion from degrees to radians
#define DEG_TO_RAD (PI / 180.0)

// Conversion from radians to degrees
#define RAD_TO_DEG (180.0 / PI)

// Structure to represent a GPS coordinate
typedef struct {
    double latitude;
    double longitude;
} GPS_Coordinate;

// Function to calculate the distance between two GPS coordinates in kilometers
double calculate_distance(GPS_Coordinate coord1, GPS_Coordinate coord2) {
    // Convert coordinates to radians
    double lat1 = coord1.latitude * DEG_TO_RAD;
    double lon1 = coord1.longitude * DEG_TO_RAD;
    double lat2 = coord2.latitude * DEG_TO_RAD;
    double lon2 = coord2.longitude * DEG_TO_RAD;

    // Calculate the difference between the coordinates
    double dLat = lat2 - lat1;
    double dLon = lon2 - lon1;

    // Calculate the square of the sine of half the difference
    double a = sin(dLat / 2) * sin(dLat / 2) + cos(lat1) * cos(lat2) * sin(dLon / 2) * sin(dLon / 2);

    // Calculate the central angle
    double c = 2 * atan2(sqrt(a), sqrt(1 - a));

    // Calculate the distance
    double distance = EARTH_RADIUS * c;

    return distance;
}

// Function to simulate GPS navigation
void simulate_navigation() {
    // Define the starting and destination coordinates
    GPS_Coordinate start_coord = {37.774929, -122.419416};
    GPS_Coordinate destination_coord = {37.332331, -121.894472};

    // Calculate the distance between the coordinates
    double distance = calculate_distance(start_coord, destination_coord);

    // Print the distance
    printf("Distance: %.2f kilometers\n", distance);
}

// Main function
int main() {
    // Simulate navigation
    simulate_navigation();

    return 0;
}