//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STRLEN 20

// Define a struct to represent a romantic quote
struct romantic_quote {
    char author[20];
    char quote[MAX_STRLEN];
};

// Function to sort an array of romantic quotes by author
void sort_by_author(struct romantic_quote quotes[]) {
    int i, j, min_index;
    struct romantic_quote temp;

    // Initialize the minimum index to 0
    min_index = 0;

    // Loop through the array of quotes
    for (i = 0; i < sizeof(quotes) / sizeof(quotes[0]); i++) {
        // Find the minimum index based on the author
        min_index = i;
        for (j = i + 1; j < sizeof(quotes) / sizeof(quotes[0]); j++) {
            if (strcmp(quotes[j].author, quotes[min_index].author) < 0) {
                min_index = j;
            }
        }

        // Swap the quotes if the author is different
        if (min_index != i) {
            temp = quotes[min_index];
            quotes[min_index] = quotes[i];
            quotes[i] = temp;
        }
    }
}

int main() {
    struct romantic_quote quotes[] = {
        {"William Shakespeare", "To be, or not to be, that is the question."},
        {"Virginia Woolf", "Love is not a feeling, it's a choice."},
        {"Jane Austen", "Happiness is not a point of arrival, but a way of traveling."},
        {"F. Scott Fitzgerald", "The only way of knowing a person is to love them without hope."},
        {"Gabriel Garcia Marquez", "Love is not a result of chance, but a choice."},
    };

    // Sort the array of quotes by author
    sort_by_author(quotes);

    // Print the sorted array of quotes
    for (int i = 0; i < sizeof(quotes) / sizeof(quotes[0]); i++) {
        printf("%s - %s\n", quotes[i].author, quotes[i].quote);
    }

    return 0;
}