//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Bind the socket to an address
    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_port = htons(8080);
    addr.sin_addr.s_addr = INADDR_ANY;
    if (bind(sockfd, (struct sockaddr *) &addr, sizeof(addr)) == -1) {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    // Listen for connections
    if (listen(sockfd, 5) == -1) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    // Accept a connection
    struct sockaddr_in client_addr;
    socklen_t client_addr_len = sizeof(client_addr);
    int client_sockfd = accept(sockfd, (struct sockaddr *) &client_addr, &client_addr_len);
    if (client_sockfd == -1) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    // Read data from the client
    char buffer[256];
    int n = read(client_sockfd, buffer, sizeof(buffer));
    if (n == -1) {
        perror("read");
        exit(EXIT_FAILURE);
    }

    // Write data to the client
    n = write(client_sockfd, buffer, n);
    if (n == -1) {
        perror("write");
        exit(EXIT_FAILURE);
    }

    // Close the client socket
    close(client_sockfd);

    // Close the server socket
    close(sockfd);

    return 0;
}