//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdint.h>
#include <stdarg.h>

#define LOG_LEVEL_TRACE 0
#define LOG_LEVEL_DEBUG 1
#define LOG_LEVEL_INFO 2
#define LOG_LEVEL_WARN 3
#define LOG_LEVEL_ERROR 4
#define LOG_LEVEL_FATAL 5

#define LOG_OUTPUT_STDOUT 0
#define LOG_OUTPUT_FILE 1

typedef struct {
    int level;
    int output;
    FILE *file;
} Logger;

void logger_init(Logger *logger, int level, int output) {
    logger->level = level;
    logger->output = output;

    if (output == LOG_OUTPUT_FILE) {
        logger->file = fopen("log.txt", "w");
        if (!logger->file) {
            printf("Failed to open log file\n");
            exit(1);
        }
    }
}

void logger_destroy(Logger *logger) {
    if (logger->file) {
        fclose(logger->file);
    }
}

void logger_log(Logger *logger, int level, const char *format,...) {
    if (level < logger->level) {
        return;
    }

    va_list args;
    va_start(args, format);

    if (logger->output == LOG_OUTPUT_STDOUT) {
        printf("[%d] ", level);
        vprintf(format, args);
        printf("\n");
    } else {
        fprintf(logger->file, "[%d] ", level);
        vfprintf(logger->file, format, args);
        fprintf(logger->file, "\n");
    }

    va_end(args);
}

int main() {
    Logger logger;
    logger_init(&logger, LOG_LEVEL_INFO, LOG_OUTPUT_FILE);

    int count = 0;
    while (count < 10) {
        logger_log(&logger, LOG_LEVEL_INFO, "Iteration %d", count);
        count++;
        sleep(1);
    }

    logger_destroy(&logger);
    return 0;
}