//LLAMA2-13B DATASET v1.0 Category: Math exercise ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Complex number structure
typedef struct {
    int real;
    int imag;
} complex;

// Function to add two complex numbers
complex add(complex a, complex b) {
    complex res;
    res.real = a.real + b.real;
    res.imag = a.imag + b.imag;
    return res;
}

// Function to subtract one complex number from another
complex subtract(complex a, complex b) {
    complex res;
    res.real = a.real - b.real;
    res.imag = a.imag - b.imag;
    return res;
}

// Function to multiply two complex numbers
complex multiply(complex a, complex b) {
    complex res;
    res.real = a.real * b.real - a.imag * b.imag;
    res.imag = a.real * b.imag + a.imag * b.real;
    return res;
}

// Function to divide one complex number by another
complex divide(complex a, complex b) {
    complex res;
    if (b.real == 0 && b.imag == 0) {
        printf("Division by zero! ");
        return res;
    }
    res.real = a.real / b.real;
    res.imag = a.imag / b.imag;
    return res;
}

// Function to calculate the magnitude of a complex number
float magnitude(complex a) {
    return sqrtf(a.real * a.real + a.imag * a.imag);
}

// Function to calculate the angle of a complex number
float angle(complex a) {
    return atan2f(a.imag, a.real);
}

int main() {
    complex a = {3, 4};
    complex b = {2, 1};
    complex c = add(a, b);
    complex d = subtract(a, b);
    complex e = multiply(a, b);
    complex f = divide(a, b);
    float m = magnitude(a);
    float ang = angle(a);

    printf("a + b = %c + %c = %c\n", a.real, a.imag, c.real, c.imag);
    printf("a - b = %c - %c = %c\n", a.real, a.imag, d.real, d.imag);
    printf("a * b = %c * %c = %c\n", a.real, a.imag, e.real, e.imag);
    printf("a / b = %c / %c = %c\n", a.real, a.imag, f.real, f.imag);
    printf("Magnitude of a = %f\n", m);
    printf("Angle of a = %f\n", ang);

    return 0;
}