//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define EPS 1e-9

typedef struct point {
    double x, y;
} point;

typedef struct line {
    point p1, p2;
} line;

typedef struct circle {
    point c;
    double r;
} circle;

double dist(point p1, point p2) {
    return sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
}

int ccw(point p1, point p2, point p3) {
    double dx1 = p2.x - p1.x, dy1 = p2.y - p1.y;
    double dx2 = p3.x - p2.x, dy2 = p3.y - p2.y;
    double t = dx1 * dy2 - dx2 * dy1;
    if (fabs(t) < EPS) return 0;
    return t > 0 ? 1 : -1;
}

int intersect_ll(line l1, line l2) {
    return ccw(l1.p1, l1.p2, l2.p1) != ccw(l1.p1, l1.p2, l2.p2) &&
           ccw(l2.p1, l2.p2, l1.p1) != ccw(l2.p1, l2.p2, l1.p2);
}

int intersect_lc(line l, circle c) {
    double dx = l.p2.x - l.p1.x, dy = l.p2.y - l.p1.y;
    double A = dx * dx + dy * dy;
    double B = 2 * (dx * (l.p1.x - c.c.x) + dy * (l.p1.y - c.c.y));
    double C = c.c.x * c.c.x + c.c.y * c.c.y;
    C += l.p1.x * l.p1.x + l.p1.y * l.p1.y;
    C -= 2 * (c.c.x * l.p1.x + c.c.y * l.p1.y);
    C -= c.r * c.r;
    double D = B * B - 4 * A * C;
    return D >= 0;
}

int intersect_cc(circle c1, circle c2) {
    return dist(c1.c, c2.c) <= c1.r + c2.r;
}

int main() {
    // Example usage:
    point p1 = {0, 0}, p2 = {1, 1}, p3 = {2, 0};
    line l1 = {p1, p2}, l2 = {p2, p3};
    circle c1 = {{0.5, 0.5}, 0.5}, c2 = {{1.5, 0.5}, 0.5};

    // Check if two lines intersect
    if (intersect_ll(l1, l2)) {
        printf("Lines l1 and l2 intersect.\n");
    } else {
        printf("Lines l1 and l2 do not intersect.\n");
    }

    // Check if a line and a circle intersect
    if (intersect_lc(l1, c1)) {
        printf("Line l1 and circle c1 intersect.\n");
    } else {
        printf("Line l1 and circle c1 do not intersect.\n");
    }

    // Check if two circles intersect
    if (intersect_cc(c1, c2)) {
        printf("Circles c1 and c2 intersect.\n");
    } else {
        printf("Circles c1 and c2 do not intersect.\n");
    }

    return 0;
}