//Falcon-180B DATASET v1.0 Category: Encryption ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <math.h>

#define DECRYPT 1
#define ENCRYPT 2

typedef struct {
    char *key;
    int mode;
} vigenere_t;

void vigenere_encrypt(vigenere_t *v, char *message) {
    int message_length = strlen(message);
    int key_length = strlen(v->key);
    int i, j, k;
    char encrypted_message[message_length];
    char key_index = 0;

    for (i = 0; i < message_length; i++) {
        encrypted_message[i] = message[i];

        if (isalpha(message[i])) {
            encrypted_message[i] = (message[i] - 'A' + v->key[key_index] - 'A') % 26 + 'A';
            key_index = (key_index + 1) % key_length;
        }
    }

    printf("Encrypted message: %s\n", encrypted_message);
}

void vigenere_decrypt(vigenere_t *v, char *message) {
    int message_length = strlen(message);
    int key_length = strlen(v->key);
    int i, j, k;
    char decrypted_message[message_length];
    char key_index = 0;

    for (i = 0; i < message_length; i++) {
        decrypted_message[i] = message[i];

        if (isalpha(message[i])) {
            decrypted_message[i] = (message[i] - 'A' - v->key[key_index] + 26) % 26 + 'A';
            key_index = (key_index + 1) % key_length;
        }
    }

    printf("Decrypted message: %s\n", decrypted_message);
}

int main() {
    vigenere_t v;
    char *message = "Hello, world!";
    char *key = "secret";
    int mode = ENCRYPT;

    v.key = key;
    v.mode = mode;

    if (mode == ENCRYPT) {
        vigenere_encrypt(&v, message);
    } else if (mode == DECRYPT) {
        vigenere_decrypt(&v, message);
    }

    return 0;
}