//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_UNITS 10
#define MAX_CONVERSIONS 5

typedef struct {
    char *name;
    double value;
} unit_t;

unit_t units[MAX_UNITS] = {
    {"inch", 0.01},
    {"foot", 0.03},
    {"yard", 0.1},
    {"mile", 0.00160934},
    {"pound", 0.0625},
    {"ounce", 0.035274},
    {"gram", 0.001},
    {"kilogram", 1000.0},
    {"meter", 0.01},
    {"kilometer", 1000.0}
};

unit_t *get_unit(char *name) {
    int i;

    for (i = 0; i < MAX_UNITS; i++) {
        if (strcmp(name, units[i].name) == 0) {
            return &units[i];
        }
    }

    return NULL;
}

double convert(double value, unit_t *from, unit_t *to) {
    double result = 0;

    if (from == NULL || to == NULL) {
        return 0;
    }

    result = value * from->value / to->value;

    return result;
}

int main() {
    double value = 5.0;
    unit_t *from, *to;

    from = get_unit("inch");
    to = get_unit("meter");

    if (from == NULL || to == NULL) {
        printf("Invalid unit selection.\n");
        return 1;
    }

    value = convert(value, from, to);

    printf("Value in meters: %f\n", value);

    return 0;
}