//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_FILES 1000
#define MAX_FILE_NAME_LENGTH 256
#define MAX_FILE_CONTENT_LENGTH 1024

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    char content[MAX_FILE_CONTENT_LENGTH];
    int size;
} file_t;

file_t files[MAX_FILES];
int num_files = 0;

void create_file(char *name, char *content) {
    if (num_files >= MAX_FILES) {
        printf("Error: too many files\n");
        return;
    }
    strcpy(files[num_files].name, name);
    strcpy(files[num_files].content, content);
    files[num_files].size = strlen(content);
    num_files++;
}

void delete_file(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            num_files--;
            memmove(&files[i], &files[i+1], (num_files - i) * sizeof(file_t));
            break;
        }
    }
}

void rename_file(char *old_name, char *new_name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, old_name) == 0) {
            strcpy(files[i].name, new_name);
            break;
        }
    }
}

void print_file_list() {
    int i;
    for (i = 0; i < num_files; i++) {
        printf("%s (%d bytes)\n", files[i].name, files[i].size);
    }
}

void print_file_content(char *name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("%s\n", files[i].content);
            break;
        }
    }
}

int main() {
    create_file("hello.txt", "Hello, world!");
    create_file("test.txt", "This is a test file.");
    print_file_list();
    print_file_content("hello.txt");
    rename_file("hello.txt", "greeting.txt");
    print_file_list();
    print_file_content("greeting.txt");
    delete_file("test.txt");
    print_file_list();
    return 0;
}