//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>

#define BUFFER_SIZE 1024

// Function prototypes
void create_pipe(int fd[2]);
void write_to_pipe(int fd[2], char* message);
void read_from_pipe(int fd[2], char* buffer);

int main() {
    int fd[2]; // File descriptors for the pipe
    char buffer[BUFFER_SIZE]; // Buffer to store the message received from the pipe

    // Create the pipe
    create_pipe(fd);

    // Write a message to the pipe
    write_to_pipe(fd, "Hello, World!");

    // Read the message from the pipe
    read_from_pipe(fd, buffer);

    // Print the message received from the pipe
    printf("Message received: %s\n", buffer);

    return 0;
}

// Function to create the pipe
void create_pipe(int fd[2]) {
    if (pipe(fd) == -1) {
        printf("Error creating pipe\n");
        exit(1);
    }
}

// Function to write a message to the pipe
void write_to_pipe(int fd[2], char* message) {
    int bytes_written = write(fd[1], message, strlen(message));

    if (bytes_written == -1) {
        printf("Error writing to pipe\n");
        exit(1);
    }
}

// Function to read a message from the pipe
void read_from_pipe(int fd[2], char* buffer) {
    int bytes_read = read(fd[0], buffer, BUFFER_SIZE);

    if (bytes_read == -1) {
        printf("Error reading from pipe\n");
        exit(1);
    }
}