//GPT-4o-mini DATASET v1.0 Category: Elevator Simulation ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stdbool.h>

#define MAX_FLOORS 10
#define NUM_ELEVATORS 2

typedef struct {
    int current_floor;
    bool is_idle;
} Elevator;

void initialize_elevators(Elevator elevators[], int count) {
    for (int i = 0; i < count; i++) {
        elevators[i].current_floor = 0; // Ground floor
        elevators[i].is_idle = true;
    }
}

void request_elevator(Elevator elevators[], int count, int requested_floor) {
    int selected_elevator = -1;
    int min_distance = MAX_FLOORS + 1;
    
    for (int i = 0; i < count; i++) {
        int distance = abs(elevators[i].current_floor - requested_floor);
        
        if (elevators[i].is_idle || distance < min_distance) {
            min_distance = distance;
            selected_elevator = i;
        }
    }
    
    if (selected_elevator != -1) {
        elevators[selected_elevator].is_idle = false;
        printf("Elevator %d moving to floor %d\n", selected_elevator, requested_floor);
        elevators[selected_elevator].current_floor = requested_floor;
        elevators[selected_elevator].is_idle = true; // Mark it as idle after reaching
        printf("Elevator %d has arrived at floor %d\n", selected_elevator, requested_floor);
    }
}

void simulate_elevator_system() {
    Elevator elevators[NUM_ELEVATORS];
    initialize_elevators(elevators, NUM_ELEVATORS);
    
    int requests[] = {3, 5, 9, 1, 2, 7, 8, 0, 4, 6}; // Sample requests
    int num_requests = sizeof(requests) / sizeof(requests[0]);
    
    for (int i = 0; i < num_requests; i++) {
        sleep(1); // Simulate time delay for more realism
        printf("Requesting elevator to floor %d\n", requests[i]);
        request_elevator(elevators, NUM_ELEVATORS, requests[i]);
    }
}

int main() {
    srand(time(NULL)); // Seed for random number generator
    printf("Welcome to the Elevator Simulation\n");
    simulate_elevator_system();
    printf("All requests processed. Elevator system shutting down.\n");
    return 0;
}