//GPT-4o-mini DATASET v1.0 Category: Pac-Man Game Clone ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <stdbool.h>

#define WIDTH 20
#define HEIGHT 10
#define MAX_GHOSTS 3

char maze[HEIGHT][WIDTH + 1] = {
    "###################",
    "#........#........#",
    "#.#####.#.#####..#.#",
    "#.......#.......#.#.#",
    "#####.#.#####.###.#.#",
    "#...#.....#...#...#.#",
    "###.#####.###.###.#.#",
    "#.............#...#.#",
    "###################",
    "###################"
};

int pacman_x = 1, pacman_y = 1;
int ghosts[MAX_GHOSTS][2] = {{8, 1}, {2, 6}, {6, 6}};
bool game_over = false;

void draw() {
    system("clear");
    for (int y = 0; y < HEIGHT; ++y) {
        printf("%s\n", maze[y]);
    }
    printf("Pac-Man is at (%d, %d)\n", pacman_x, pacman_y);
    printf("Controls: WASD to move, Q to quit.\n");
}

void update_ghosts() {
    for (int i = 0; i < MAX_GHOSTS; i++) {
        if (ghosts[i][0] != -1) {
            if (pacman_x > ghosts[i][0]) ghosts[i][0]++; // move right
            else if (pacman_x < ghosts[i][0]) ghosts[i][0]--; // move left
            
            if (pacman_y > ghosts[i][1]) ghosts[i][1]++; // move down
            else if (pacman_y < ghosts[i][1]) ghosts[i][1]--; // move up
            
            if (ghosts[i][0] == pacman_x && ghosts[i][1] == pacman_y) {
                game_over = true;
            }
        }
    }
}

void move_pacman(char direction) {
    int new_x = pacman_x, new_y = pacman_y;
    switch (direction) {
        case 'W': new_y--; break; // Up
        case 'A': new_x--; break; // Left
        case 'S': new_y++; break; // Down
        case 'D': new_x++; break; // Right
        case 'Q': game_over = true; return; // Quit
    }

    if (maze[new_y][new_x] == '.') {
        pacman_x = new_x;
        pacman_y = new_y;
    }
}

int kbhit() {
    struct termios oldt, newt;
    int ch;
    int oldf;

    tcgetattr(STDIN_FILENO, &oldt);
    newt = oldt;
    newt.c_lflag &= ~(ICANON | ECHO);
    tcsetattr(STDIN_FILENO, TCSANOW, &newt);
    oldf = fcntl(STDIN_FILENO, F_GETFL, 0);
    fcntl(STDIN_FILENO, F_SETFL, oldf | O_NONBLOCK);

    ch = getchar();

    tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
    fcntl(STDIN_FILENO, F_SETFL, oldf);
    
    if(ch != EOF) {
        ungetc(ch, stdin);
        return 1;
    }

    return 0;
}

char getch() {
    char buf = 0;
    struct termios old = {0};
    
    if(tcgetattr(0, &old) < 0)
        perror ("tcsetattr()");
    
    old.c_lflag &= ~ICANON;
    old.c_lflag &= ~ECHO;
    tcsetattr(0, TCSANOW, &old);
    if(read(0, &buf, 1) < 0)
        perror ("read()");
    
    old.c_lflag |= ICANON;
    old.c_lflag |= ECHO;
    tcsetattr(0, TCSANOW, &old);
    
    return (buf);
}

int main() {
    while (!game_over) {
        draw();
        update_ghosts();
        if (game_over) break;
        
        if (kbhit()) {
            char direction = getch();
            move_pacman(direction);
        }

        usleep(200000); // to slow down the game
    }
    
    printf("Game Over! Pac-Man was caught by a ghost.\n");
    return 0;
}