//GPT-4o-mini DATASET v1.0 Category: Matrix operations ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>

#define SIZE 3 // Define the size of the matrix

// Function prototypes
void initializeMatrix(int matrix[SIZE][SIZE]);
void printMatrix(int matrix[SIZE][SIZE]);
void addMatrices(int matrix1[SIZE][SIZE], int matrix2[SIZE][SIZE], int result[SIZE][SIZE]);
void subtractMatrices(int matrix1[SIZE][SIZE], int matrix2[SIZE][SIZE], int result[SIZE][SIZE]);
void multiplyMatrices(int matrix1[SIZE][SIZE], int matrix2[SIZE][SIZE], int result[SIZE][SIZE]);
void transposeMatrix(int matrix[SIZE][SIZE], int result[SIZE][SIZE]);

int main() {
    int matrix1[SIZE][SIZE], matrix2[SIZE][SIZE];
    int result[SIZE][SIZE];
    
    printf("Initializing Matrix 1:\n");
    initializeMatrix(matrix1);
    printMatrix(matrix1);
    
    printf("Initializing Matrix 2:\n");
    initializeMatrix(matrix2);
    printMatrix(matrix2);
    
    printf("Adding Matrices:\n");
    addMatrices(matrix1, matrix2, result);
    printMatrix(result);
    
    printf("Subtracting Matrices:\n");
    subtractMatrices(matrix1, matrix2, result);
    printMatrix(result);
    
    printf("Multiplying Matrices:\n");
    multiplyMatrices(matrix1, matrix2, result);
    printMatrix(result);
    
    printf("Transposing Matrix 1:\n");
    transposeMatrix(matrix1, result);
    printMatrix(result);
    
    printf("Transposing Matrix 2:\n");
    transposeMatrix(matrix2, result);
    printMatrix(result);

    return 0;
}

void initializeMatrix(int matrix[SIZE][SIZE]) {
    for(int i = 0; i < SIZE; i++) {
        for(int j = 0; j < SIZE; j++) {
            matrix[i][j] = rand() % 10; // Random number between 0-9
        }
    }
}

void printMatrix(int matrix[SIZE][SIZE]) {
    for(int i = 0; i < SIZE; i++) {
        for(int j = 0; j < SIZE; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}

void addMatrices(int matrix1[SIZE][SIZE], int matrix2[SIZE][SIZE], int result[SIZE][SIZE]) {
    for(int i = 0; i < SIZE; i++) {
        for(int j = 0; j < SIZE; j++) {
            result[i][j] = matrix1[i][j] + matrix2[i][j];
        }
    }
}

void subtractMatrices(int matrix1[SIZE][SIZE], int matrix2[SIZE][SIZE], int result[SIZE][SIZE]) {
    for(int i = 0; i < SIZE; i++) {
        for(int j = 0; j < SIZE; j++) {
            result[i][j] = matrix1[i][j] - matrix2[i][j];
        }
    }
}

void multiplyMatrices(int matrix1[SIZE][SIZE], int matrix2[SIZE][SIZE], int result[SIZE][SIZE]) {
    for(int i = 0; i < SIZE; i++) {
        for(int j = 0; j < SIZE; j++) {
            result[i][j] = 0;
            for(int k = 0; k < SIZE; k++) {
                result[i][j] += matrix1[i][k] * matrix2[k][j];
            }
        }
    }
}

void transposeMatrix(int matrix[SIZE][SIZE], int result[SIZE][SIZE]) {
    for(int i = 0; i < SIZE; i++) {
        for(int j = 0; j < SIZE; j++) {
            result[j][i] = matrix[i][j];
        }
    }
}