//Code Llama-13B DATASET v1.0 Category: System event logger ; Style: single-threaded
/*
 * system_event_logger.c
 *
 * Simple program to log system events
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define BUFFER_SIZE 1024

// Structure to hold system event data
typedef struct {
    char event_type[32];
    char event_message[BUFFER_SIZE];
} system_event_t;

// Function to log system events
void log_system_event(system_event_t *event) {
    // Get current time
    time_t rawtime;
    struct tm *timeinfo;
    time(&rawtime);
    timeinfo = localtime(&rawtime);

    // Format event message
    char *event_message = event->event_message;
    char *event_type = event->event_type;
    char formatted_message[BUFFER_SIZE];
    sprintf(formatted_message, "%s - %s", event_type, event_message);

    // Write event to file
    FILE *fp;
    fp = fopen("system_events.log", "a");
    if (fp == NULL) {
        perror("Error opening file");
        exit(1);
    }
    fprintf(fp, "%s\n", formatted_message);
    fclose(fp);
}

int main() {
    // Create system event structure
    system_event_t event;
    strcpy(event.event_type, "Info");
    strcpy(event.event_message, "System started");

    // Log system event
    log_system_event(&event);

    return 0;
}