//Falcon-180B DATASET v1.0 Category: Wireless Network Scanner ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>

#define BUF_SIZE 1024

struct sockaddr_in server_addr;
int sockfd;

void error(char *msg) {
    perror(msg);
    exit(1);
}

int main(int argc, char *argv[]) {
    if (argc!= 2) {
        printf("Usage: %s <IP address>\n", argv[0]);
        exit(1);
    }

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        error("socket failed");
    }

    server_addr.sin_family = AF_INET;
    inet_pton(AF_INET, argv[1], &server_addr.sin_addr);
    server_addr.sin_port = htons(80);

    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        error("connect failed");
    }

    char buf[BUF_SIZE];
    memset(buf, 0, BUF_SIZE);

    send(sockfd, "GET / HTTP/1.1\r\nHost:\r\n\r\n", strlen("GET / HTTP/1.1\r\nHost:\r\n\r\n"), 0);

    int bytes_received = recv(sockfd, buf, BUF_SIZE, 0);
    if (bytes_received <= 0) {
        error("recv failed");
    }

    printf("Received response:\n%s\n", buf);

    close(sockfd);
    return 0;
}