//Falcon2-11B DATASET v1.0 Category: Product Inventory System ; Style: safe
#include <stdio.h>
#include <stdlib.h>

// Structure to hold item information
struct Item {
    char name[20];
    double price;
};

// Function to add an item to the inventory
void addItem(struct Item* inventory, const char* name, double price) {
    inventory->name[strlen(name)] = '\0'; // Null terminate string
    inventory->price = price;
}

// Function to remove an item from the inventory
void removeItem(struct Item* inventory, const char* name) {
    int i;
    for (i = 0; i < sizeof(inventory)/sizeof(*inventory); i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            // Found item, remove it from list
            memmove(&inventory[i], &inventory[i+1], (sizeof(inventory) - (i+1)*sizeof(*inventory))/sizeof(*inventory));
            return;
        }
    }
    // Item not found
    fprintf(stderr, "Item '%s' not found in inventory\n", name);
}

// Function to display the inventory
void displayInventory(struct Item* inventory) {
    int i;
    for (i = 0; i < sizeof(inventory)/sizeof(*inventory); i++) {
        printf("Item: %s\n", inventory[i].name);
        printf("Price: $%.2f\n", inventory[i].price);
    }
}

int main() {
    // Create an empty inventory
    struct Item inventory[10];

    // Add some items to the inventory
    addItem(inventory, "Apple", 0.50);
    addItem(inventory, "Banana", 0.30);
    addItem(inventory, "Orange", 0.75);

    // Display the inventory
    displayInventory(inventory);

    // Remove an item from the inventory
    removeItem(inventory, "Orange");

    // Display the updated inventory
    displayInventory(inventory);

    return 0;
}