//GPT-4o-mini DATASET v1.0 Category: Table Game ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define GRID_SIZE 10
#define PLAYER_COUNT 2

void initializeGame(int players[PLAYER_COUNT]);
void displayGrid(int players[PLAYER_COUNT]);
void rollDiceAndMove(int *playerPosition);
int checkWinner(int playerPosition);

int main() {
    srand(time(NULL));  // Seed for random number generation
    int players[PLAYER_COUNT] = {0, 0};  // Player positions
    int winner = -1;
    
    initializeGame(players);
    
    while (winner == -1) {
        for (int i = 0; i < PLAYER_COUNT; i++) {
            printf("Player %d's turn.\n", i + 1);
            printf("Current position: %d\n", players[i]);
            printf("Press Enter to roll the dice...");
            getchar();  // Wait for player input

            rollDiceAndMove(&players[i]);
            displayGrid(players);
            
            winner = checkWinner(players[i]);
            if (winner != -1) {
                printf("Player %d wins!\n", winner + 1);
                break;  // Exit the game loop if we have a winner
            }
        }
    }
    
    return 0;
}

void initializeGame(int players[PLAYER_COUNT]) {
    for (int i = 0; i < PLAYER_COUNT; i++) {
        players[i] = 0;  // Start all players at position 0
    }
    printf("Welcome to the Dice Rolling Game!\n");
    printf("Players will take turns to roll the dice.\n");
    printf("The first to reach the end of the grid (position %d) wins!\n\n", GRID_SIZE);
}

void displayGrid(int players[PLAYER_COUNT]) {
    for (int position = 0; position <= GRID_SIZE; position++) {
        printf("Position %2d: ", position);
        for (int i = 0; i < PLAYER_COUNT; i++) {
            if (players[i] == position) {
                printf("P%d ", i + 1);
            }
        }
        printf("\n");
    }
    printf("\n");
}

void rollDiceAndMove(int *playerPosition) {
    int diceRoll = (rand() % 6) + 1;  // Generate random dice roll between 1 to 6
    printf("You rolled a %d!\n", diceRoll);
    *playerPosition += diceRoll;  // Update player position
    if (*playerPosition > GRID_SIZE) {
        *playerPosition = GRID_SIZE;  // Cap position at GRID_SIZE
    }
}

int checkWinner(int playerPosition) {
    if (playerPosition >= GRID_SIZE) {
        return 1;  // Return winner index (players are zero-indexed)
    }
    return -1;  // No winner yet
}