//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define MSGKEY 1234

typedef struct {
    long mtype;
    char mtext[256];
} message_t;

int main() {
    int msqid;
    message_t msg;

    // Create a message queue
    msqid = msgget(MSGKEY, IPC_CREAT | 0666);
    if (msqid < 0) {
        perror("msgget");
        exit(1);
    }

    // Initialize message
    msg.mtype = 1;
    strcpy(msg.mtext, "Hello world!");

    // Send message to the queue
    if (msgsnd(msqid, &msg, sizeof(msg.mtext), 0) < 0) {
        perror("msgsnd");
        exit(1);
    }

    // Receive message from the queue
    if (msgrcv(msqid, &msg, sizeof(msg.mtext), 1, 0) < 0) {
        perror("msgrcv");
        exit(1);
    }

    // Print the message
    printf("Received message: %s\n", msg.mtext);

    // Remove the message queue
    if (msgctl(msqid, IPC_RMID, NULL) < 0) {
        perror("msgctl");
        exit(1);
    }

    return 0;
}