//GEMINI-pro DATASET v1.0 Category: Color Code Converter ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the RGB color structure
typedef struct {
  unsigned char red;
  unsigned char green;
  unsigned char blue;
} RGB;

// Define the HSV color structure
typedef struct {
  float hue;
  float saturation;
  float value;
} HSV;

// Convert RGB to HSV
HSV rgb_to_hsv(RGB rgb) {
  HSV hsv;

  float min, max, delta;
  min = rgb.red < rgb.green ? rgb.red : rgb.green;
  min = min < rgb.blue ? min : rgb.blue;

  max = rgb.red > rgb.green ? rgb.red : rgb.green;
  max = max > rgb.blue ? max : rgb.blue;

  hsv.value = max;
  delta = max - min;

  if (delta < 0.00001f) {
    hsv.hue = 0;
    hsv.saturation = 0;
  } else {
    if (rgb.red == max)
      hsv.hue = (rgb.green - rgb.blue) / delta;
    else if (rgb.green == max)
      hsv.hue = 2 + (rgb.blue - rgb.red) / delta;
    else
      hsv.hue = 4 + (rgb.red - rgb.green) / delta;
    hsv.hue *= 60;
    if (hsv.hue < 0)
      hsv.hue += 360;

    if (hsv.value > 0) {
      hsv.saturation = delta / hsv.value;
    } else {
      hsv.saturation = 0;
    }
  }

  return hsv;
}

// Convert HSV to RGB
RGB hsv_to_rgb(HSV hsv) {
  RGB rgb;

  float chroma = hsv.saturation * hsv.value;
  float hue_dash = hsv.hue / 60.0f;
  float x = chroma * (1 - fabs(fmod(hue_dash, 2) - 1));

  if (hue_dash < 1) {
    rgb.red = chroma;
    rgb.green = x;
    rgb.blue = 0;
  } else if (hue_dash < 2) {
    rgb.red = x;
    rgb.green = chroma;
    rgb.blue = 0;
  } else if (hue_dash < 3) {
    rgb.red = 0;
    rgb.green = chroma;
    rgb.blue = x;
  } else if (hue_dash < 4) {
    rgb.red = 0;
    rgb.green = x;
    rgb.blue = chroma;
  } else if (hue_dash < 5) {
    rgb.red = x;
    rgb.green = 0;
    rgb.blue = chroma;
  } else if (hue_dash < 6) {
    rgb.red = chroma;
    rgb.green = 0;
    rgb.blue = x;
  }

  float m = hsv.value - chroma;
  rgb.red += m;
  rgb.green += m;
  rgb.blue += m;

  rgb.red *= 255;
  rgb.green *= 255;
  rgb.blue *= 255;

  return rgb;
}

// Get the hue of a color
int get_hue(RGB rgb) {
  HSV hsv = rgb_to_hsv(rgb);
  return (int)hsv.hue;
}


// Print the color code
void print_color_code(RGB rgb) {
  HSV hsv = rgb_to_hsv(rgb);
  printf("The color code is: #%02X%02X%02X\n", rgb.red, rgb.green, rgb.blue);
  printf("The hue is: %.2f degrees\n", hsv.hue);
  printf("The saturation is: %.2f%%\n", hsv.saturation * 100);
  printf("The value is: %.2f%%\n", hsv.value * 100);
}

int main() {
  // Define the RGB color
  RGB rgb = {255, 0, 0};

  // Print the color code
  print_color_code(rgb);

  return 0;
}