//Falcon2-11B DATASET v1.0 Category: Basic Unix-like Shell ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int main() {
    // Initialize global variables
    char* command = NULL;
    int argc = 0;
    char** argv = NULL;

    // Check for invalid command-line arguments
    while ((argc = getopt(argc, argv, "c:"))!= -1) {
        switch (argc) {
            case 'c':
                command = optarg;
                break;
            default:
                fprintf(stderr, "Invalid argument: -%c\n", optopt);
                exit(EXIT_FAILURE);
        }
    }

    // Check for missing command-line arguments
    if (argc!= 1) {
        fprintf(stderr, "Missing command-line argument\n");
        exit(EXIT_FAILURE);
    }

    // Check for empty command-line argument
    if (command == NULL || *command == '\0') {
        fprintf(stderr, "Empty command-line argument\n");
        exit(EXIT_FAILURE);
    }

    // Execute the command
    int status = system(command);

    // Check for command execution errors
    if (status == -1) {
        perror("Failed to execute command");
        exit(EXIT_FAILURE);
    }

    // Print the command execution output
    char* output = NULL;
    size_t output_size = 0;
    if (getcwd(output, sizeof(output)) == NULL) {
        perror("Failed to get current working directory");
        exit(EXIT_FAILURE);
    }
    if (system("pwd") == -1) {
        perror("Failed to execute pwd command");
        exit(EXIT_FAILURE);
    }
    if (system("echo $PWD") == -1) {
        perror("Failed to execute echo command");
        exit(EXIT_FAILURE);
    }
    if (system("echo $PWD | grep -o '[a-zA-Z0-9]+'") == -1) {
        perror("Failed to execute grep command");
        exit(EXIT_FAILURE);
    }
    output_size = strlen(output);
    output = (char*)malloc(output_size + 1);
    if (output == NULL) {
        perror("Failed to allocate memory for output");
        exit(EXIT_FAILURE);
    }
    strncpy(output, output, output_size);
    output[output_size] = '\0';
    printf("Command execution output:\n%s\n", output);

    // Free memory
    if (command!= NULL) {
        free(command);
    }
    if (argv!= NULL) {
        for (int i = 0; argv[i]!= NULL; i++) {
            free(argv[i]);
        }
        free(argv);
    }
    if (output!= NULL) {
        free(output);
    }

    // Exit program
    exit(EXIT_SUCCESS);
}