//GPT-4o-mini DATASET v1.0 Category: Pattern printing ; Style: expert-level
#include <stdio.h>

void printSpaces(int n) {
    for (int i = 0; i < n; i++) {
        printf(" ");
    }
}

void printOddNumbersTriangle(int rows) {
    int num = 1;  // Start with the first odd number
    for (int i = 1; i <= rows; i++) {
        // Print leading spaces
        printSpaces(rows - i);
        // Print odd numbers
        for (int j = 1; j <= i; j++) {
            printf("%d ", num);
            num += 2;  // Move to the next odd number
        }
        printf("\n");
    }
}

void printReverseAlphabetPyramid(int rows) {
    for (int i = 0; i < rows; i++) {
        // Print leading spaces
        printSpaces(i);
        // Print characters in reverse order from 'Z'
        for (int j = rows; j > i; j--) {
            printf("%c ", 'Z' - j + 1);
        }
        printf("\n");
    }
}

void printDiamondPattern(int n) {
    // Upper part
    for (int i = 1; i <= n; i++) {
        printSpaces(n - i);
        for (int j = 1; j <= (2 * i - 1); j++) {
            printf("*");
        }
        printf("\n");
    }
    // Lower part
    for (int i = n - 1; i >= 1; i--) {
        printSpaces(n - i);
        for (int j = 1; j <= (2 * i - 1); j++) {
            printf("*");
        }
        printf("\n");
    }
}

void printFibonacciSpiral(int n) {
    int a = 0, b = 1, next;
    printf("Fibonacci Spiral:\n");
    for (int i = 0; i < n; i++) {
        printf("%d ", a);
        next = a + b;
        a = b;
        b = next;
    }
    printf("\n");
}

void printHollowSquare(int n) {
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            if (i == 0 || i == n - 1 || j == 0 || j == n - 1) {
                printf("*");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

void printZigzagPattern(int n) {
    for (int i = 0; i < n; i++) {
        // Zigzag pattern logic
        for (int j = 0; j < n; j++) {
            if ((i + j) % 4 == 0) {
                printf("*");
            } else if (i % 4 == 1 && j == n - 1) {
                printf("*");
            } else if (i % 4 == 2 && j == 0) {
                printf("*");
            } else if (i % 4 == 3 && j == n - 1) {
                printf("*");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

int main() {
    int rows = 5;
    printf("Odd Numbers Triangle:\n");
    printOddNumbersTriangle(rows);
    printf("\nReverse Alphabet Pyramid:\n");
    printReverseAlphabetPyramid(rows);
    printf("\nDiamond Pattern:\n");
    printDiamondPattern(rows);
    printf("\n");
    
    int fibonacciCount = 10;
    printFibonacciSpiral(fibonacciCount);
    
    int hollowSquareSize = 5;
    printf("\nHollow Square:\n");
    printHollowSquare(hollowSquareSize);
    
    int zigzagSize = 7;
    printf("\nZigzag Pattern:\n");
    printZigzagPattern(zigzagSize);
    
    return 0;
}