//GPT-4o-mini DATASET v1.0 Category: Digital Watermarking ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_MESSAGE_LENGTH 256
#define IMAGE_WIDTH 5
#define IMAGE_HEIGHT 5

// Function to embed a romantic watermark message into image pixel values
void embedWatermark(unsigned char image[IMAGE_HEIGHT][IMAGE_WIDTH][3], const char *message) {
    int msgLength = strlen(message);
    
    for (int i = 0; i < IMAGE_HEIGHT; i++) {
        for (int j = 0; j < IMAGE_WIDTH; j++) {
            // Modify Red channel to embed the message
            if (i * IMAGE_WIDTH + j < msgLength) {
                image[i][j][0] = (image[i][j][0] & 0xFE) | (message[i * IMAGE_WIDTH + j] & 0x01);
            }
        }
    }
}

// Function to extract the romantic watermark message
void extractWatermark(unsigned char image[IMAGE_HEIGHT][IMAGE_WIDTH][3], char *message) {
    for (int i = 0; i < IMAGE_HEIGHT; i++) {
        for (int j = 0; j < IMAGE_WIDTH; j++) {
            // Read the Red channel to retrieve the watermark
            if (i * IMAGE_WIDTH + j < MAX_MESSAGE_LENGTH) {
                message[i * IMAGE_WIDTH + j] = (image[i][j][0] & 0x01) + '0'; 
            }
        }
    }
    message[IMAGE_HEIGHT * IMAGE_WIDTH] = '\0'; // Null terminate the string
}

// Romantic message
const char *romanticMessage() {
    return "You are my heart, my soul, my everything!";
}

int main() {
    // Create an image with some arbitrary pixel values
    unsigned char image[IMAGE_HEIGHT][IMAGE_WIDTH][3] = {
        {{255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {255, 255, 0}, {255, 255, 255}},
        {{255, 105, 180}, {240, 128, 128}, {144, 238, 144}, {255, 20, 147}, {0, 255, 255}},
        {{255, 218, 185}, {105, 105, 105}, {255, 69, 0}, {70, 130, 180}, {255, 192, 203}},
        {{255, 0, 0}, {0, 0, 128}, {128, 0, 128}, {146, 255, 0}, {0, 255, 127}},
        {{135, 206, 235}, {255, 228, 196}, {154, 205, 50}, {211, 211, 211}, {0, 0, 0}}
    };

    // Declare a buffer for the extracted watermark message
    char message[MAX_MESSAGE_LENGTH];
    
    // Print the original romantic message
    const char *romance = romanticMessage();
    printf("Original romantic message: %s\n", romance);
    
    // Embed the romantic message into the image
    embedWatermark(image, romance);
    printf("The romantic message has been embedded into the image.\n");

    // Extract the embedded message
    extractWatermark(image, message);
    
    // Print the extracted message
    printf("Extracted romantic message: %s\n", message);
    
    return 0;
}