//GEMINI-pro DATASET v1.0 Category: Interprocess communication ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

#define SEM_KEY 0x1234

// Initialize semaphore set
int init_sem(int nsems) {
    int semid;
    semid = semget(SEM_KEY, nsems, IPC_CREAT | 0666);
    if (semid < 0) {
        perror("semget");
        return -1;
    }
    return semid;
}

// Wait on semaphore
int sem_wait(int semid, int semnum) {
    struct sembuf op;
    op.sem_num = semnum;
    op.sem_op = -1;
    op.sem_flg = 0;
    return semop(semid, &op, 1);
}

// Signal semaphore
int sem_signal(int semid, int semnum) {
    struct sembuf op;
    op.sem_num = semnum;
    op.sem_op = 1;
    op.sem_flg = 0;
    return semop(semid, &op, 1);
}

// Child process
void child(int semid) {
    int i;

    // Wait for parent to signal
    sem_wait(semid, 0);

    // Print child process ID
    for (i = 0; i < 10; i++) {
        printf("Child: %d\n", getpid());
        sleep(1);
    }

    // Signal parent
    sem_signal(semid, 1);

    exit(0);
}

// Parent process
int main() {
    pid_t cpid;
    int semid;

    // Initialize semaphore set
    semid = init_sem(2);
    if (semid < 0) {
        exit(1);
    }

    // Create child process
    cpid = fork();
    if (cpid < 0) {
        perror("fork");
        exit(1);
    }

    // Parent process
    if (cpid > 0) {
        int i;

        // Print parent process ID
        for (i = 0; i < 10; i++) {
            printf("Parent: %d\n", getpid());
            sleep(1);
        }

        // Signal child
        sem_signal(semid, 0);

        // Wait for child to signal
        sem_wait(semid, 1);

        // Remove semaphore set
        semctl(semid, 0, IPC_RMID);

        exit(0);
    }

    // Child process
    else {
        child(semid);
    }

    return 0;
}