//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Weather types
enum weather_type {
    SUNNY,
    CLOUDY,
    RAINING,
    STORMY
};

// Weather simulation struct
struct weather {
    enum weather_type type;
    int temperature;
    int humidity;
    int wind_speed;
};

// Function to generate a random weather simulation
struct weather generate_weather() {
    struct weather weather;

    // Generate a random weather type
    weather.type = rand() % 4;

    // Generate a random temperature
    weather.temperature = rand() % 40;

    // Generate a random humidity
    weather.humidity = rand() % 100;

    // Generate a random wind speed
    weather.wind_speed = rand() % 20;

    return weather;
}

// Function to print a weather simulation
void print_weather(struct weather weather) {
    printf("Weather: ");

    switch (weather.type) {
        case SUNNY:
            printf("Sunny");
            break;
        case CLOUDY:
            printf("Cloudy");
            break;
        case RAINING:
            printf("Raining");
            break;
        case STORMY:
            printf("Stormy");
            break;
    }

    printf(", Temperature: %d degrees Celsius, Humidity: %d%%, Wind Speed: %d km/h\n", weather.temperature, weather.humidity, weather.wind_speed);
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Generate a random weather simulation
    struct weather weather = generate_weather();

    // Print the weather simulation
    print_weather(weather);

    return 0;
}