//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the structure of a task
typedef struct task {
    int id;             // The ID of the task
    int arrival_time;   // The time at which the task arrives
    int processing_time;// The time required to process the task
} task;

// Define the comparison function for sorting tasks by arrival time
int compare_tasks(const void *a, const void *b) {
    const task *task1 = (const task *)a;
    const task *task2 = (const task *)b;

    return task1->arrival_time - task2->arrival_time;
}

// Function to perform the scheduling algorithm
void schedule_tasks(task *tasks, int num_tasks) {
    // Sort the tasks by arrival time
    qsort(tasks, num_tasks, sizeof(task), compare_tasks);

    // Initialize the current time and waiting time
    int current_time = 0;
    int waiting_time = 0;

    // Iterate over the tasks
    for (int i = 0; i < num_tasks; i++) {
        // If the current time is less than the arrival time of the task, wait until the task arrives
        if (current_time < tasks[i].arrival_time) {
            current_time = tasks[i].arrival_time;
        }

        // Add the waiting time to the total waiting time
        waiting_time += current_time - tasks[i].arrival_time;

        // Process the task
        current_time += tasks[i].processing_time;
    }

    // Calculate the average waiting time
    float avg_waiting_time = (float)waiting_time / num_tasks;

    // Print the average waiting time
    printf("The average waiting time is %.2f\n", avg_waiting_time);
}

// Main function
int main() {
    // Define the tasks
    task tasks[] = {
        {1, 0, 3},
        {2, 2, 6},
        {3, 4, 4},
        {4, 6, 5}
    };

    // Get the number of tasks
    int num_tasks = sizeof(tasks) / sizeof(task);

    // Schedule the tasks
    schedule_tasks(tasks, num_tasks);

    return 0;
}