//Falcon-180B DATASET v1.0 Category: Memory Game ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 4
#define COLS 4
#define BOARD_SIZE (ROWS * COLS)

void init_board(char board[BOARD_SIZE]);
void print_board(const char board[BOARD_SIZE]);
int check_win(const char board[BOARD_SIZE]);
void flip_card(char board[BOARD_SIZE], int row, int col);
void play_game(char board[BOARD_SIZE]);

int main() {
    char board[BOARD_SIZE];
    srand(time(NULL));
    init_board(board);
    play_game(board);
    return 0;
}

void init_board(char board[BOARD_SIZE]) {
    int i, j;
    for (i = 0; i < BOARD_SIZE; i++) {
        board[i] = (i % 2)? 'X' : 'O';
    }
}

void print_board(const char board[BOARD_SIZE]) {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            printf("%c ", board[i * COLS + j]);
        }
        printf("\n");
    }
}

int check_win(const char board[BOARD_SIZE]) {
    int i;
    for (i = 0; i < BOARD_SIZE; i++) {
        if (board[i] == 'X') {
            return 1;
        }
    }
    return 0;
}

void flip_card(char board[BOARD_SIZE], int row, int col) {
    if (row >= 0 && row < ROWS && col >= 0 && col < COLS && board[row * COLS + col] == 'X') {
        board[row * COLS + col] = 'O';
    } else if (row >= 0 && row < ROWS && col >= 0 && col < COLS && board[row * COLS + col] == 'O') {
        board[row * COLS + col] = 'X';
    }
}

void play_game(char board[BOARD_SIZE]) {
    int row, col;
    while (!check_win(board)) {
        printf("Enter row and column: ");
        scanf("%d %d", &row, &col);
        if (row >= 0 && row < ROWS && col >= 0 && col < COLS) {
            flip_card(board, row, col);
            if (check_win(board)) {
                printf("You win!\n");
                break;
            }
        } else {
            printf("Invalid input.\n");
        }
    }
    print_board(board);
}