//MISTRAL-7B DATASET v1.0 Category: Data mining ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define ALPHABET_SIZE 26

typedef struct {
    char letter;
    int count;
} letter_count;

letter_count letter_counts[ALPHABET_SIZE];

void load_text_file(const char *filename) {
    FILE *file = fopen(filename, "r");

    if (file == NULL) {
        printf("Error: Unable to open file '%s'\n", filename);
        exit(EXIT_FAILURE);
    }

    char c;
    while ((c = fgetc(file)) != EOF) {
        if (isalpha(c)) {
            int index = tolower(c) - 'a';
            letter_counts[index].count++;
        }
    }

    fclose(file);
}

void print_letter_counts() {
    printf("\nLetter frequencies:\n");

    for (int i = 0; i < ALPHABET_SIZE; i++) {
        if (letter_counts[i].count > 0) {
            printf("%c: %d\n", letter_counts[i].letter, letter_counts[i].count);
        }
    }
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        printf("Usage: %s <path_to_text_file>\n", argv[0]);
        return EXIT_FAILURE;
    }

    const char *filename = argv[1];
    load_text_file(filename);
    print_letter_counts();

    return EXIT_SUCCESS;
}