//Falcon-180B DATASET v1.0 Category: Database Indexing System ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#define MAX_KEY_LENGTH 100
#define NUM_THREADS 4

// Structure for each thread to store its data
typedef struct {
    char key[MAX_KEY_LENGTH];
    int value;
    int thread_id;
} ThreadData;

// Function for each thread to execute
void *thread_function(void *arg) {
    ThreadData *data = (ThreadData *) arg;

    // Do some work with the data
    printf("Thread %d processing key: %s, value: %d\n", data->thread_id, data->key, data->value);

    // Sleep for a random amount of time to simulate work
    usleep(rand() % 1000000);

    return NULL;
}

int main() {
    // Initialize the thread data
    ThreadData threads[NUM_THREADS];
    for (int i = 0; i < NUM_THREADS; i++) {
        sprintf(threads[i].key, "key_%d", i);
        threads[i].value = i * 10;
        threads[i].thread_id = i;
    }

    // Create the threads
    pthread_t threads_id[NUM_THREADS];
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_create(&threads_id[i], NULL, thread_function, &threads[i]);
    }

    // Join the threads
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads_id[i], NULL);
    }

    return 0;
}